% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r.version.check.R
\name{r.version.check}
\alias{r.version.check}
\title{Compare \R versions}
\usage{
r.version.check(date)
}
\arguments{
\item{date}{date (in the format "\%Y-\%m-\%d"), Required date for the package.}
}
\value{
a named \code{list} with the following elements:
\describe{
\item{r.using.full}{\R version currently in use}
\item{r.using.major}{Major version number of the \R version currently in use}
\item{r.using.minor}{Minor version number of the \R version currently in use}
\item{r.using.majmin}{The Major.minor version number of the \R version currently in use}
\item{r.using.patch}{Patch version number of the \R version currently in use}
\item{r.need.full}{\R version currently in use at \code{date}}
\item{r.need.major}{Major version number of the \R version in use at \code{date}}
\item{r.need.minor}{Minor version number of the \R version in use at \code{date}}
\item{r.using.majmin}{The Major.minor version number of the \R version currently in use}
\item{r.need.patch}{Version number of the \R version in use at \code{date}, with
the maximum patch version available today.}
}
}
\description{
Compare the current R version to the \R version at a given \code{date}.`
}
