% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_names.R
\name{mark_names}
\alias{mark_names}
\alias{mark_name<-}
\title{Mark Names}
\usage{
mark_names(x)

mark_name(x) <- value
}
\arguments{
\item{x}{only \link[spatstat.geom]{ppp.object} is tested, for now}
}
\value{
Function \code{\link[=mark_names]{mark_names()}} returns the names of the \link[spatstat.geom]{marks}
of a \link[spatstat.geom]{ppp.object}, when its \link[spatstat.geom]{markformat} is \code{'dataframe'}.
Otherwise, an error is returned.

Syntactic sugar \code{\link[=mark_name<-]{mark_name<-()}} returns a \link[spatstat.geom]{ppp.object}
of \code{'dataframe'} \link[spatstat.geom]{markformat}.
}
\description{
Get the names of \link[spatstat.geom]{marks}.
Assign a name to \link[spatstat.geom]{marks}, when \link[spatstat.geom]{markformat} is \code{'vector'}.
}
\details{
Syntactic sugar \code{\link[=mark_name<-]{mark_name<-()}} converts a \link[spatstat.geom]{ppp.object}
of \code{'vector'} \link[spatstat.geom]{markformat} into \code{'dataframe'} \link[spatstat.geom]{markformat},
and name this \link[base]{ncol}-\code{1L} \link[base]{data.frame} \link[spatstat.geom]{marks}
by \code{value}.
}
\examples{
library(spatstat.data)
mark_names(betacells)
# ?waka
tryCatch(mark_names(waka), error = identity)
waka2 = waka
mark_name(waka2) = 'dbh' # tree diameter at breast height `dbh`
mark_names(waka2)
unstack(waka) # no name
unstack(waka2) # has name
}
\keyword{internal}
