% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{lm_effsize_ci}
\alias{lm_effsize_ci}
\title{Confidence intervals for partial eta-squared and omega-squared for linear models.}
\usage{
lm_effsize_ci(lm_object, conf.level = 0.95, nboot = 1000)
}
\arguments{
\item{lm_object}{The \code{stats::lm} linear model object.}

\item{conf.level}{Level of confidence for the confidence interval.}

\item{nboot}{Number of bootstrap samples for confidence intervals for partial
eta-squared and omega-squared.}
}
\value{
A dataframe with results from \code{stats::lm()} with partial eta-squared,
omega-squared, and bootstrapped confidence interval for the same.
}
\description{
This function will convert a linear model object to a dataframe
containing statistical details for all effects along with partial
eta-squared effect size and its confidence interval.
}
\author{
Indrajeet Patil
}
