% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsaot_indices.R
\name{print.gsaot_indices}
\alias{print.gsaot_indices}
\title{Print Optimal Transport Sensitivity indices information}
\usage{
\method{print}{gsaot_indices}(x, ...)
}
\arguments{
\item{x}{An object generated by \code{\link{ot_indices}},
\code{\link{ot_indices_1d}}, or \code{\link{ot_indices_wb}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The information contained in argument \code{x}
}
\description{
Print Optimal Transport Sensitivity indices information
}
\examples{
N <- 1000

mx <- c(1, 1, 1)
Sigmax <- matrix(data = c(1, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 1), nrow = 3)

x1 <- rnorm(N)
x2 <- rnorm(N)
x3 <- rnorm(N)

x <- cbind(x1, x2, x3)
x <- mx + x \%*\% chol(Sigmax)

A <- matrix(data = c(4, -2, 1, 2, 5, -1), nrow = 2, byrow = TRUE)
y <- t(A \%*\% t(x))

x <- data.frame(x)

M <- 25

# Calculate sensitivity indices
sensitivity_indices <- ot_indices(x, y, M)
print(sensitivity_indices)

}
