#' @title  Add Health data about substance use and abuse
#'
#' @docType data
#'
#' @usage data(AddHealth)
#'
#' @format A data frame with 5114 observations on the following 6 variables.
#' \describe{
#'   \item{AID}{a numeric vector of observations' ID.}
#'   \item{Smoking}{a factor with levels "Yes" or "No"; H4TO1: Have you ever smoked an entire cigarette? }
#'   \item{Alcohol}{a factor with levels "Yes" or "No"; H4TO33: Have you had a drink of beer, wine, or liquor more than two or three times? Do not include sips or tastes from someone else’s drink.}
#'   \item{Drug}{a factor with levels "Yes" or "No"; H4TO65E: Have you every used any of the following drugs? (65E) Other types of illegal drugs, such as LSD, PCP, ecstasy, heroin, or mushrooms; or inhalants. }
#'   \item{Marijuana}{a factor with levels "Yes" or "No"; H4TO65B: Have you every used any of the following drugs? (65B) Marijuana (hash, bhang, ganja) }
#'   \item{Cocaine}{a factor with levels "Yes" or "No"; H4TO65C: Have you every used any of the following drugs? (65C) Cocaine (crack, coca leaves)}
#' }
#'
#' @keywords datasets
#'
#' @references Harris, Kathleen Mullan, and Udry, J. Richard. National Longitudinal Study of Adolescent to Adult Health (Add Health), 1994-2008 [Public Use]. Ann Arbor, MI: Carolina Population Center, University of North Carolina-Chapel Hill [distributor], Inter-university Consortium for Political and Social Research [distributor], 2018-08-06. https://doi.org/10.3886/ICPSR21600.v21
#'
#' @source \href{https://www.icpsr.umich.edu/icpsrweb/ICPSR/studies/21600/datadocumentation#}{ICPSR Add Health}
#'
#' @examples
#' data(AddHealth)
#' str(AddHealth)
#' head(AddHealth)
#'
#' @details This AddHealth data consist of 5,144 participants' responses with a randomly generated ID variable and five item variables, such as Smoking, Alcohol, Other Types of Illegal Drug, Marijuana, and Cocaine. The responses of the five items are dichotomous as either ``Yes'' or ``No'' and are treated the other missing codes as systematic missing. This data can be obtained from the National Longitudinal Study of Adolescent to Adult Health (Add Health; Harris et al., 2009) where the study have mainly focused on the investigation of how health factors in childhood affect adult outcomes. In terms of data collection, there have been four additional waves since 1994. In this package, the data of a specific section of substance use at the wave IV is pre-installed.
#'
"AddHealth"
