% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls-methods.R
\name{anova.gsl_nls}
\alias{anova.gsl_nls}
\title{Anova tables}
\usage{
\method{anova}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{Additional objects inheriting from class \code{"gsl_nls"}.}
}
\value{
A data.frame object of class \code{"anova"} similar to \code{\link[stats]{anova}} representing the
analysis-of-variance table of the fitted model objects when printed.
}
\description{
Returns the analysis of variance (or deviance) tables for two or
more fitted \code{"gsl_nls"} objects.
}
\examples{
## data
set.seed(1)
x <- 1:10
y <- 1 + 0.5 * (1:10) + rnorm(10, sd = 0.1)
## models
obj1 <- gsl_nls(fn = y ~ b * x, data = data.frame(x = x, y = y), start = c(b = 1))
obj2 <- gsl_nls(fn = y ~ a + b * x, data = data.frame(x = x, y = y), start = c(a = 0, b = 1))
anova(obj1, obj2)
}
\seealso{
\code{\link[stats]{anova}}
}
