% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_sound_speed_t_exact}
\alias{gsw_sound_speed_t_exact}
\title{Sound Speed in Seawater}
\usage{
gsw_sound_speed_t_exact(SA, t, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
sound speed [ m/s ]
}
\description{
Sound Speed in Seawater
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <- c(      10,      50,     125,     250,     600,    1000)
sound_speed <- gsw_sound_speed_t_exact(SA,CT,p)
expect_equal(sound_speed/1e3, c(1.542615803587414, 1.542703534065789, 1.530844979136360,
                              1.494409996920661, 1.487377102518027, 1.483934609078705))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_sound_speed_t_exact.html}
}
\seealso{
Other things related to sound: \code{\link{gsw_sound_speed_ice}},
  \code{\link{gsw_sound_speed}}
}
