% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_spiciness0}
\alias{gsw_spiciness0}
\title{Seawater Spiciness at p=0 dbar}
\usage{
gsw_spiciness0(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
spiciness [ kg/m^3 ]
}
\description{
Calculate seawater spiciness referenced to 0 dbar (i.e. the surface).
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
spiciness <- gsw_spiciness0(SA, CT)
expect_equal(spiciness, c(5.728998558542941, 5.749940496782486, 4.163547112671111,
                          1.069362556641764, 0.426428274444305, 0.089725188494086))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_spiciness0.html}
}
