% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_sound_speed_ice}
\alias{gsw_sound_speed_ice}
\title{Sound speed in ice}
\usage{
gsw_sound_speed_ice(t, p)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
sound speed [ m/s ]
}
\description{
Speed of sound in ice.
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600, -10.8863, -8.4036)
p <- c(      10,       50,      125,      250,      600,    1000)
speed <- gsw_sound_speed_ice(t, p)
expect_equal(speed/1e3, c(3.111311360346254, 3.116492565497544, 3.115833462003452,
                         3.115637032488204, 3.115377253092692, 3.113321384499191))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_sound_speed_ice.html}
}
\seealso{
Other things related to sound: \code{\link{gsw_sound_speed_t_exact}},
  \code{\link{gsw_sound_speed}}
}
