% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_freezing_first_derivatives}
\alias{gsw_CT_freezing_first_derivatives}
\title{First Derivatives of Conservative Temperature for Freezing Water}
\usage{
gsw_CT_freezing_first_derivatives(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
A list containing \code{CTfreezing_SA} [ K/(g/kg) ], the derivative of
Conservative Temperature with respect to Absolute Salinity at constant
potential temperature, and \code{CTfreezing_p} [ unitless], the derivative of
Conservative Temperature with respect to pressure at constant
Absolute Salinity.
}
\description{
First Derivatives of Conservative Temperature for Freezing Water
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(                 34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(                       10,      50,     125,     250,     600,    1000)
saturation_fraction <- c(      1,     0.8,     0.6,     0.5,     0.4,       0)
r <- gsw_CT_freezing_first_derivatives(SA, p, saturation_fraction)
stopifnot(all.equal(r$CTfreezing_SA,
    c(-0.058193253897272, -0.058265158334170, -0.058345661671901,
     -0.058373842446463, -0.058534544740846, -0.058730846361252)))
stopifnot(all.equal(r$CTfreezing_p/1e-7,
    c(-0.765300390432684, -0.766942996466485, -0.769892679988284,
      -0.774561011527902, -0.787769143040504, -0.802771548245855)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_freezing_first_derivatives.html}
}
