% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_CT_freezing_first_derivatives_poly}
\alias{gsw_CT_freezing_first_derivatives_poly}
\title{First Derivatives of Conservative Temperature for Freezing Water (Polynomial version)}
\usage{
gsw_CT_freezing_first_derivatives_poly(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
A list containing \code{CTfreezing_SA} [ K/(g/kg) ], the derivative of
Conservative Temperature with respect to Absolute Salinity at constant
potential temperature, and \code{CTfreezing_p} [ unitless], the derivative of
Conservative Temperature with respect to pressure at constant
Absolute Salinity.
}
\description{
First Derivatives of Conservative Temperature for Freezing Water (Polynomial version)
}
\section{Implementation Note}{

This R function uses a wrapper to a C function
contained within the GSW-C system as updated 2021-03-27
at \url{https://github.com/TEOS-10/GSW-C}
with git commit `f7bfebf44f686034636facb09852f1d5760c27f5`.
In turn, that C function uses data from the
\code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version is no longer displayed on the
TEOS-10.org website. Therefore, in the interests of making
GSW-R be self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip}
on 2021-0706, the .mat file was stored in
the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset
used in GSW-R was created based on that .mat file.
Please consult \url{http://www.teos-10.org} to learn more about
the various TEOS-10 software systems.
}

\examples{
SA <- c(                 34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(                       10,      50,     125,     250,     600,    1000)
saturation_fraction <- c(      1,     0.8,     0.6,     0.5,     0.4,       0)
r <- gsw_CT_freezing_first_derivatives_poly(SA, p, saturation_fraction)
stopifnot(all.equal(r$CTfreezing_SA,
    c(-0.058191181082769, -0.058263310660779, -0.058343573188907,
     -0.058370514075271, -0.058528023214462, -0.058722959729433)))
stopifnot(all.equal(r$CTfreezing_p/1e-7,
    c(-0.765690732336706, -0.767310677213890, -0.770224214219328,
     -0.774843488962665, -0.787930403016584, -0.802821704643775)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_CT_freezing_first_derivatives_poly.html}
}
