% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SA_from_SP_Baltic}
\alias{gsw_SA_from_SP_Baltic}
\title{Convert from Practical Salinity to Absolute Salinity (Baltic)}
\usage{
gsw_SA_from_SP_Baltic(SP, longitude, latitude)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]}

\item{longitude}{longitude in decimal degrees, positive to the east of Greenwich. (This
is called \code{long} in the TEOS-10 Matlab code.)}

\item{latitude}{latitude in decimal degrees, positive to the north of the equator. (This
is called \code{lat} in the TEOS-10 Matlab code.)}
}
\value{
Absolute Salinity [ g/kg ]
}
\description{
Calculate Absolute Salinity from Practical Salinity, pressure,
longitude, and latitude.
}
\details{
If SP is a matrix and if its dimensions correspond to the
lengths of longitude and latitude, then the latter are
converted to analogous matrices with \code{\link{expand.grid}}.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SP <- c( 6.5683, 6.6719, 6.8108, 7.2629, 7.4825, 10.2796)
lon <- c(    20,     20,     20,     20,     20,      20)
lat <- c(    59,     59,     59,     59,     59,      59)
SA <- gsw_SA_from_SP_Baltic(SP, lon, lat)
stopifnot(all.equal(SA, c(6.669945432342856, 6.773776430742856, 6.912986138057142,
                          7.366094191885713, 7.586183837142856, 10.389520570971428)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SA_from_SP_Baltic.html}
}
\seealso{
Other things related to salinity: 
\code{\link{gsw_C_from_SP}()},
\code{\link{gsw_SA_from_SP}()},
\code{\link{gsw_SA_from_Sstar}()},
\code{\link{gsw_SP_from_C}()},
\code{\link{gsw_SP_from_SA}()},
\code{\link{gsw_SP_from_SK}()},
\code{\link{gsw_SP_from_SR}()},
\code{\link{gsw_SP_from_Sstar}()},
\code{\link{gsw_SR_from_SP}()},
\code{\link{gsw_Sstar_from_SA}()},
\code{\link{gsw_Sstar_from_SP}()},
\code{\link{gsw_deltaSA_from_SP}()}
}
\concept{things related to salinity}
