% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SP_salinometer}
\alias{gsw_SP_salinometer}
\title{Practical Salinity from Salinometer Reading}
\usage{
gsw_SP_salinometer(ratio, temperature)
}
\arguments{
\item{ratio}{Conductivity ratio [ unitless ].
(This is called \code{Rt} in the GSW documentation.)}

\item{temperature}{Bath temperature [ degC ].
(This is called \code{t} in the GSW documentation.)}
}
\value{
Practical salinity on the PSS-77 scale [ unitless ]
}
\description{
Calculate Practical Salinity from salinometer readings
of conductivity ratio and bath temperature.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
ratio <- c( 0.9345,  0.95123,  0.91807,  0.8886, 0.8169, 0.6687)
temperature <-  c(28.7856, 28.4329, 22.8103, 10.2600, 6.8863, 4.4036)
SP <- gsw_SP_salinometer(ratio, temperature)
stopifnot(all.equal(SP,
        c(32.431728787558541, 33.085035719966307, 31.800791917322833,
            30.692490757036179, 27.979281308696116, 22.474597460508491)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SP_salinometer.html}
}
