% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_latentheat_melting}
\alias{gsw_latentheat_melting}
\title{Latent Heat of Melting}
\usage{
gsw_latentheat_melting(SA, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
latent heat of freezing [ J/kg ]
}
\description{
Latent Heat of Melting
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(      10,      50,     125,     250,     600,    1000)
lh <- gsw_latentheat_melting(SA, p)
stopifnot(all.equal(lh/1e5, c(3.299496680271213, 3.298613352397986, 3.297125622834541,
                              3.294973895330757, 3.288480445559747, 3.280715862416388)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_latentheat_melting.html}
}
\seealso{
Other things related to latent heat: 
\code{\link{gsw_latentheat_evap_CT}()},
\code{\link{gsw_latentheat_evap_t}()}
}
\concept{things related to latent heat}
