% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{from_column}
\alias{from_column}
\title{Reference a column of values for certain parameters}
\usage{
from_column(column, na_value = NULL, fn = NULL)
}
\arguments{
\item{column}{\emph{Column name}

\verb{scalar<character>} // \strong{required}

A single column name in quotation marks. Values will be extracted from this
column and provided to compatible arguments.}

\item{na_value}{\emph{Default replacement for \code{NA} values}

\verb{scalar<character|numeric|logical>} // \emph{default:} \code{NULL} (\code{optional})

A single value to replace any \code{NA} values in the \code{column}. Take care to
provide a value that is of the same type as the \code{column} values to avoid
any undesirable coercion.}

\item{fn}{\emph{Function to apply}

\verb{function|formula} // \emph{default:} \code{NULL} (\code{optional})

If a function is provided here, any values extracted from the table
\code{column} (except \code{NA} values) can be mutated.}
}
\value{
A list object of class \code{gt_column}.
}
\description{
It can be useful to obtain parameter values from a column in a
\strong{gt} for functions that operate on the table body and stub cells. For
example, you might want to indent row labels in the stub. You could call
\code{\link[=tab_stub_indent]{tab_stub_indent()}} and indent different rows to various indentation levels.
However, each level of indentation applied necessitates a new call of that
function. To make this better, we can use indentation values available in a
table column via the \code{from_column()} helper function. For the
\code{\link[=tab_stub_indent]{tab_stub_indent()}} case, you'd invoke this helper at the \code{indent} argument
and specify the column that has the values.
}
\section{Functions that allow the use of the \code{from_column()} helper}{


Only certain functions (and furthermore a subset of arguments within each)
support the use of \code{from_column()} for accessing varying parameter values.
These functions are:
\itemize{
\item \code{\link[=tab_stub_indent]{tab_stub_indent()}}
\item \code{\link[=fmt_number]{fmt_number()}}
\item \code{\link[=fmt_integer]{fmt_integer()}}
\item \code{\link[=fmt_scientific]{fmt_scientific()}}
\item \code{\link[=fmt_engineering]{fmt_engineering()}}
\item \code{\link[=fmt_percent]{fmt_percent()}}
\item \code{\link[=fmt_partsper]{fmt_partsper()}}
\item \code{\link[=fmt_fraction]{fmt_fraction()}}
\item \code{\link[=fmt_currency]{fmt_currency()}}
\item \code{\link[=fmt_roman]{fmt_roman()}}
\item \code{\link[=fmt_index]{fmt_index()}}
\item \code{\link[=fmt_spelled_num]{fmt_spelled_num()}}
\item \code{\link[=fmt_bytes]{fmt_bytes()}}
\item \code{\link[=fmt_date]{fmt_date()}}
\item \code{\link[=fmt_time]{fmt_time()}}
\item \code{\link[=fmt_datetime]{fmt_datetime()}}
\item \code{\link[=fmt_url]{fmt_url()}}
\item \code{\link[=fmt_image]{fmt_image()}}
\item \code{\link[=fmt_flag]{fmt_flag()}}
\item \code{\link[=fmt_markdown]{fmt_markdown()}}
\item \code{\link[=fmt_passthrough]{fmt_passthrough()}}
}

Within help documents for each of these functions you'll find the
\emph{Compatibility of arguments with the \code{from_column()} helper function} section
and sections like these describe which arguments support the use of
\code{from_column()}.
}

\section{Examples}{


The \code{from_column()} function can be used in a variety of formatting functions
so that values for common options don't have to be static, they can change in
every row (so long as you have a column of compatible option values). Here's
an example where we have a table of repeating numeric values along with a
column of currency codes. We can format the numbers to currencies with
\code{\link[=fmt_currency]{fmt_currency()}} and use \code{from_column()} to reference the column of currency
codes, giving us values that are each formatted as having a different
currency.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::tibble(
  amount = rep(30.75, 6),
  curr = c("USD", "EUR", "GBP", "CAD", "AUD", "JPY"),
) |>
  gt() |>
  fmt_currency(currency = from_column(column = "curr"))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_from_column_1.png" alt="This image of a table was generated from the first code example in the `from_column()` help file." style="width:100\%;">
}}

Let's summarize the \code{\link{gtcars}} dataset to get a set of rankings of car
manufacturer by country of origin. The \code{n} column represents the number of
cars a manufacturer has within this dataset and we can use that column as a
way to size the text. We do that in the \code{\link[=tab_style]{tab_style()}} call; the
\code{from_column()} function is used within the \code{\link[=cell_text]{cell_text()}} statement to
fashion different font sizes from that \code{n} column. This is done in
conjunction with the \code{fn} argument of \code{from_column()}, which helps to tweak
the values in \code{n} to get a useful range of font sizes.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  dplyr::select(mfr, ctry_origin) |>
  dplyr::group_by(mfr, ctry_origin) |>
  dplyr::count() |>
  dplyr::ungroup() |>
  dplyr::arrange(ctry_origin) |>
  gt(groupname_col = "ctry_origin") |>
  tab_style(
    style = cell_text(
      size = from_column(
        column = "n",
        fn = function(x) paste0(5 + (x * 3), "px")
      )
    ),
    locations = cells_body()
  ) |>
  tab_style(
    style = cell_text(align = "center"),
    locations = cells_row_groups()
  ) |>
  cols_hide(columns = n) |>
  tab_options(column_labels.hidden = TRUE) |>
  opt_all_caps() |>
  opt_vertical_padding(scale = 0.25) |>
  cols_align(align = "center", columns = mfr)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_from_column_2.png" alt="This image of a table was generated from the second code example in the `from_column()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-5
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{define_units}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{stub}()},
\code{\link{system_fonts}()}
}
\concept{helper functions}
