% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cell_text}
\alias{cell_text}
\title{Helper for defining custom text styles for table cells}
\usage{
cell_text(
  color = NULL,
  font = NULL,
  size = NULL,
  align = NULL,
  v_align = NULL,
  style = NULL,
  weight = NULL,
  stretch = NULL,
  decorate = NULL,
  transform = NULL,
  whitespace = NULL,
  indent = NULL
)
}
\arguments{
\item{color}{\emph{Text color}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The text color can be modified through the \code{color} argument.}

\item{font}{\emph{Font (or collection of fonts) used for text}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

The font or collection of fonts (subsequent font names are) used as
fallbacks.}

\item{size}{\emph{Text size}

\verb{scalar<numeric|integer|character>} // \emph{default:} \code{NULL} (\code{optional})

The size of the font. Can be provided as a number that is assumed to
represent \code{px} values (or could be wrapped in the \code{\link[=px]{px()}} helper function).
We can also use one of the following absolute size keywords: \code{"xx-small"},
\code{"x-small"}, \code{"small"}, \code{"medium"}, \code{"large"}, \code{"x-large"}, or
\code{"xx-large"}.}

\item{align}{\emph{Text alignment}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The text in a cell can be horizontally aligned though one of the following
options: \code{"center"}, \code{"left"}, \code{"right"}, or \code{"justify"}.}

\item{v_align}{\emph{Vertical alignment}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

The vertical alignment of the text in the cell can be modified through the
options \code{"middle"}, \code{"top"}, or \code{"bottom"}.}

\item{style}{\emph{Text style}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Can be one of either \code{"normal"}, \code{"italic"}, or \code{"oblique"}.}

\item{weight}{\emph{Font weight}

\verb{scalar<character|numeric|integer>} // \emph{default:} \code{NULL} (\code{optional})

The weight of the font can be modified thorough a text-based option such as
\code{"normal"}, \code{"bold"}, \code{"lighter"}, \code{"bolder"}, or, a numeric value between
\code{1} and \code{1000}, inclusive. Note that only variable fonts may support the
numeric mapping of weight.}

\item{stretch}{\emph{Stretch text}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Allows for text to either be condensed or expanded. We can use one of the
following text-based keywords to describe the degree of
condensation/expansion: \code{"ultra-condensed"}, \code{"extra-condensed"},
\code{"condensed"}, \code{"semi-condensed"}, \code{"normal"}, \code{"semi-expanded"},
\code{"expanded"}, \code{"extra-expanded"}, or \code{"ultra-expanded"}. Alternatively, we
can supply percentage values from \verb{0\\\%} to \verb{200\\\%}, inclusive. Negative
percentage values are not allowed.}

\item{decorate}{\emph{Decorate text}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Allows for text decoration effect to be applied. Here, we can use
\code{"overline"}, \code{"line-through"}, or \code{"underline"}.}

\item{transform}{\emph{Transform text}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Allows for the transformation of text. Options are \code{"uppercase"},
\code{"lowercase"}, or \code{"capitalize"}.}

\item{whitespace}{\emph{White-space options}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

A white-space preservation option. By default, runs of white-space will be
collapsed into single spaces but several options exist to govern how
white-space is collapsed and how lines might wrap at soft-wrap
opportunities. The options are \code{"normal"}, \code{"nowrap"}, \code{"pre"},
\code{"pre-wrap"}, \code{"pre-line"}, and \code{"break-spaces"}.}

\item{indent}{\emph{Text indentation}

\verb{scalar<numeric|integer|character>} // \emph{default:} \code{NULL} (\code{optional})

The indentation of the text. Can be provided as a number that is assumed to
represent \code{px} values (or could be wrapped in the \code{\link[=px]{px()}} helper function).
Alternatively, this can be given as a percentage (easily constructed with
\code{\link[=pct]{pct()}}).}
}
\value{
A list object of class \code{cell_styles}.
}
\description{
This helper function can be used with \code{\link[=tab_style]{tab_style()}}, which itself allows for
the setting of custom styles to one or more cells. We can also define several
styles within a single call of \code{cell_text()} and \code{\link[=tab_style]{tab_style()}} will reliably
apply those styles to the targeted element.
}
\section{Examples}{


Let's use the \code{\link{exibble}} dataset to create a simple, two-column \strong{gt} table
(keeping only the \code{num} and \code{currency} columns). With \code{\link[=tab_style]{tab_style()}}
(called twice), we'll selectively add style to the values formatted with
\code{\link[=fmt_number]{fmt_number()}}. We do this by using \code{cell_text()} in the \code{style} argument of
\code{tab_style()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(num, currency) |>
  gt() |>
  fmt_number(decimals = 1) |>
  tab_style(
    style = cell_text(weight = "bold"),
    locations = cells_body(
      columns = num,
      rows = num >= 5000
    )
  ) |>
  tab_style(
    style = cell_text(style = "italic"),
    locations = cells_body(
      columns = currency,
      rows = currency < 100
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cell_text_1.png" alt="This image of a table was generated from the first code example in the `cell_text()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-25
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{from_column}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{nanoplot_options}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{row_group}()},
\code{\link{stub}()},
\code{\link{system_fonts}()},
\code{\link{unit_conversion}()}
}
\concept{helper functions}
