% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_merge_uncert}
\alias{cols_merge_uncert}
\title{Merge columns to a value-with-uncertainty column}
\usage{
cols_merge_uncert(
  data,
  col_val,
  col_uncert,
  rows = everything(),
  sep = " +/- ",
  autohide = TRUE
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{col_val}{\emph{Column to target for base values}

\verb{<column-targeting expression>} // \strong{required}

The column that contains values for the start of the range. While select
helper functions such as \code{\link[=starts_with]{starts_with()}} and \code{\link[=ends_with]{ends_with()}} can be used for
column targeting, it's recommended that a single column name be used. This
is to ensure that exactly one column is provided here.}

\item{col_uncert}{\emph{Column or columns to target for uncertainty values}

\verb{<column-targeting expression>} // \strong{required}

The most common case involves supplying a single column with uncertainties;
these values will be combined with those in \code{col_val}. Less commonly, the
lower and upper uncertainty bounds may be different. For that case, two
columns representing the lower and upper uncertainty values away from
\code{col_val}, respectively, should be provided. While select helper functions
such as \code{\link[=starts_with]{starts_with()}} and \code{\link[=ends_with]{ends_with()}} can be used for column targeting,
it's recommended that one or two column names be explicitly provided in a
vector.}

\item{rows}{\emph{Rows to target}

\verb{<row-targeting expression>} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
participate in the merging process. The default \code{\link[=everything]{everything()}} results in
all rows in \code{columns} being formatted. Alternatively, we can supply a
vector of row IDs within \code{c()}, a vector of row indices, or a select
helper function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}},
\code{\link[=matches]{matches()}},  \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use
expressions to filter down to the rows we need
(e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{sep}{\emph{Separator text for uncertainties}

\verb{scalar<character>} // \emph{default:} \code{" +/- "}

The separator text that contains the uncertainty mark for a single
uncertainty value. The default value of \code{" +/- "} indicates that an
appropriate plus/minus mark will be used depending on the output context.
Should you want this special symbol to be taken literally, it can be
supplied within the \code{\link[=I]{I()}} function.}

\item{autohide}{\emph{Automatic hiding of the \code{col_uncert} column(s)}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

An option to automatically hide any columns specified in \code{col_uncert}. Any
columns with their state changed to 'hidden' will behave the same as
before, they just won't be displayed in the finalized table.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{cols_merge_uncert()} is a specialized variant of \code{\link[=cols_merge]{cols_merge()}}. It takes as
input a base value column (\code{col_val}) and either: (1) a single uncertainty
column, or (2) two columns representing lower and upper uncertainty bounds.
These columns will be essentially merged in a single column (that of
\code{col_val}). What results is a column with values and associated
uncertainties, and any columns specified in \code{col_uncert} are hidden from
appearing the output table.
}
\section{Comparison with other column-merging functions}{


This function could be somewhat replicated using \code{\link[=cols_merge]{cols_merge()}} in the case
where a single column is supplied for \code{col_uncert}, however,
\code{cols_merge_uncert()} employs the following specialized semantics for \code{NA}
handling:
\enumerate{
\item \code{NA}s in \code{col_val} result in missing values for the merged column (e.g.,
\code{NA} + \code{0.1} = \code{NA})
\item \code{NA}s in \code{col_uncert} (but not \code{col_val}) result in base values only for
the merged column (e.g., \code{12.0} + \code{NA} = \code{12.0})
\item \code{NA}s both \code{col_val} and \code{col_uncert} result in missing values for the
merged column (e.g., \code{NA} + \code{NA} = \code{NA})
}

Any resulting \code{NA} values in the \code{col_val} column following the merge
operation can be easily formatted using \code{\link[=sub_missing]{sub_missing()}}.

This function is part of a set of four column-merging functions. The other
three are the general \code{\link[=cols_merge]{cols_merge()}} function and the specialized
\code{\link[=cols_merge_range]{cols_merge_range()}} and \code{\link[=cols_merge_n_pct]{cols_merge_n_pct()}} functions. These functions
operate similarly, where the non-target columns can be optionally hidden from
the output table through the \code{hide_columns} or \code{autohide} options.
}

\section{Examples}{


Let's use the \code{\link{exibble}} dataset to create a simple, two-column \strong{gt} table
(keeping only the \code{num} and \code{currency} columns). We'll format the \code{num}
column with the \code{\link[=fmt_number]{fmt_number()}} function. Next we merge the \code{currency} and
\code{num} columns into the \code{currency} column; this will contain a base value and
an uncertainty and it's all done using the \code{cols_merge_uncert()} function.
After the merging process, the column label for the \code{currency} column is
updated with \code{\link[=cols_label]{cols_label()}} to better describe the content.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(num, currency) |>
  dplyr::slice(1:7) |>
  gt() |>
  fmt_number(
    columns = num,
    decimals = 3,
    use_seps = FALSE
  ) |>
  cols_merge_uncert(
    col_val = currency,
    col_uncert = num
  ) |>
  cols_label(currency = "value + uncert.")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_merge_uncert_1.png" alt="This image of a table was generated from the first code example in the `cols_merge_uncert()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

5-15
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other column modification functions: 
\code{\link{cols_add}()},
\code{\link{cols_align}()},
\code{\link{cols_align_decimal}()},
\code{\link{cols_hide}()},
\code{\link{cols_label}()},
\code{\link{cols_label_with}()},
\code{\link{cols_merge}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_move}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_nanoplot}()},
\code{\link{cols_unhide}()},
\code{\link{cols_units}()},
\code{\link{cols_width}()}
}
\concept{column modification functions}
