% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_table_outline}
\alias{opt_table_outline}
\title{Option to wrap an outline around the entire table}
\usage{
opt_table_outline(data, style = "solid", width = px(3), color = "#D3D3D3")
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{style, width, color}{The style, width, and color properties for the table
outline. By default, these are \code{"solid"}, \code{px(3)} (or, \code{"3px"}), and
\code{"#D3D3D3"}. If \code{"none"} is used then the outline is removed and any values
provided for \code{width} and \code{color} will be ignored (i.e., not set).}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
This function puts an outline of consistent \code{style}, \code{width}, and \code{color}
around the entire table. It'll write over any existing outside lines so long
as the \code{width} is larger that of the existing lines. The default value of
\code{style} (\code{"solid"}) will draw a solid outline, whereas a value of \code{"none"}
will remove any present outline.
}
\section{Figures}{

\if{html}{\figure{man_opt_table_outline_1.png}{options: width=100\%}}

\if{html}{\figure{man_opt_table_outline_2.png}{options: width=100\%}}
}

\section{Function ID}{

9-8
}

\examples{
# Use `exibble` to create a gt table with
# a number of table parts added; have an
# outline wrap around the entire table by
# using `opt_table_outline()`
tab_1 <-
  exibble \%>\%
  gt(rowname_col = "row", groupname_col = "group") \%>\%
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = list(
      min = ~min(., na.rm = TRUE),
      max = ~max(., na.rm = TRUE)
    )) \%>\%
  grand_summary_rows(
    columns = currency,
    fns = list(
      total = ~sum(., na.rm = TRUE)
    )) \%>\%
  tab_source_note(source_note = "This is a source note.") \%>\%
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) \%>\%
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) \%>\%
  opt_table_outline()

# Remove the table outline with the
# `style = "none"` option
tab_2 <-
  tab_1 \%>\%
  opt_table_outline(style = "none")

}
\seealso{
Other Table Option Functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_vertical_padding}()}
}
\concept{Table Option Functions}
