% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_index.R
\name{gt_index}
\alias{gt_index}
\title{Return the underlying data, arranged by the internal index}
\usage{
gt_index(gt_object, column, as_vector = TRUE)
}
\arguments{
\item{gt_object}{An existing gt table object}

\item{column}{The column name that you intend to extract, accepts tidyeval semantics (ie \code{mpg} instead of \code{"mpg"})}

\item{as_vector}{A logical indicating whether you'd like just the column indicated as a vector, or the entire dataframe}
}
\value{
A vector or a \code{tibble}
}
\description{
This is a utility function to extract the underlying data from
a \code{gt} table. You can use it with a saved \code{gt} table, in the pipe (\verb{\%>\%})
or even within most other \code{gt} functions (eg \code{tab_style()}). It defaults to
returning the column indicated as a vector, so that you can work with the
values. Typically this is used with logical statements to affect one column
based on the values in that specified secondary column.
Alternatively, you can extract the entire ordered data according to the
internal index as a \code{tibble}. This allows for even more complex steps
based on multiple indices.
}
\section{Figures}{

\if{html}{\figure{gt_index_style.png}{options: width=50\%}}
}

\section{Function ID}{

2-20
}

\examples{
library(gt)

# This is a key step, as gt will create the row groups
# based on first observation of the unique row items
# this sampling will return a row-group order for cyl of 6,4,8

set.seed(1234)
sliced_data <- mtcars \%>\%
  dplyr::group_by(cyl) \%>\%
  dplyr::slice_head(n = 3) \%>\%
  dplyr::ungroup() \%>\%
  # randomize the order
  dplyr::slice_sample(n = 9)

# not in "order" yet
sliced_data$cyl

# But unique order of 6,4,8
unique(sliced_data$cyl)

# creating a standalone basic table
test_tab <- sliced_data \%>\%
  gt(groupname_col = "cyl")

# can style a specific column based on the contents of another column
tab_out_styled <- test_tab \%>\%
  tab_style(locations = cells_body(mpg, rows = gt_index(., am) == 0),
            style = cell_fill("red")
  )

# OR can extract the underlying data in the "correct order"
# according to the internal gt structure, ie arranged by group
# by cylinder, 6,4,8
gt_index(test_tab, mpg, as_vector = FALSE)

# note that the order of the index data is
# not equivalent to the order of the input data
# however all the of the rows still match
sliced_data
}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
