% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gtfs.R
\name{filter_by_route_id}
\alias{filter_by_route_id}
\title{Filter GTFS data by route ids}
\usage{
filter_by_route_id(gtfs_data, route_ids)
}
\arguments{
\item{gtfs_data}{A list of data.tables read using gtfs2gps::reag_gtfs().}

\item{route_ids}{A vector of route ids belonging to the routes of the
gtfs_data data. Note that route_id might be loaded by gtfs2gps::read_gtfs()
as a string or a number, depending on the available values.}
}
\value{
A filtered GTFS data.
}
\description{
Filter a GTFS data by its route ids, subsetting routes
and trips. It also removes the
unnecessary stop_times, shapes, frequencies (if exist in a feed), 
and stops accordingly.
}
\examples{
warsaw <- read_gtfs(system.file("extdata/warsaw.zip", package="gtfs2gps"))

subset <- filter_by_route_id(warsaw, c("15", "175"))
}
