% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_gtfs_feeds.R
\name{merge_gtfs_feeds}
\alias{merge_gtfs_feeds}
\title{Merge multiple GTFS feeds into a single one}
\usage{
merge_gtfs_feeds(gtfs_list)
}
\arguments{
\item{gtfs_list}{A list or a vector of GTFS.zip file names.}
}
\value{
A single list of data.tables, where each index represents the respective GTFS file name.
}
\description{
Build a single GTFS by joinning together the elements of multiple GTFS feeds.
}
\examples{

# get a list of GTFS feeds
spo <- system.file("extdata/saopaulo.zip", package = "gtfs2gps")
poa <- system.file("extdata/poa.zip", package = "gtfs2gps")
gtfs_list <- list(spo, poa)

new_gtfs <- merge_gtfs_feeds(gtfs_list)
}
