% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_listing.R
\name{tbl_listing}
\alias{tbl_listing}
\title{Data Listing Table}
\usage{
tbl_listing(data, group_by = NULL, bold_headers = TRUE)
}
\arguments{
\item{data}{a data frame}

\item{group_by}{Single variable name indicating a grouping variable.
Default is \code{NULL} for no grouping variable. When specified, a grouping
row will be added to the first column. See details below.}

\item{bold_headers}{logical indicating whether to bold column headers.
Default is \code{TRUE}}
}
\value{
gtsummary data listing
}
\description{
Function creates a gtsummary-class listing of data. Column labels are
used as column headers, when present.
The listing prints observations in the order of the input data.
}
\section{group_by}{


The grouping column and the first column in the table will be combined
and the type/class may be converted to common type/class for both columns.
However, if either the \verb{group_by=} column or the first column are factors,
the factor column(s) will first be converted to character.

The groups are ordered according to the grouping
variable's type (i.e.,  character, numeric, or factor).
}

\section{Details}{


The purpose of \code{tbl_listing()} is to add support for printing data frames,
while taking advantage of the \{gtsummary\} defaults, e.g. ability to print
to most output formats, using print themes to have a common style to all
tables in a document, etc.

While the output of \code{tbl_listing()} is class \code{'gtsummary'}, these tables
are not meant to be merged with other \code{'gtsummary'} tables with \code{tbl_merge()},
or reporting table contents with \code{inline_text()}. The reason is that a
proper \code{'gtsummary'} contains
\href{https://www.danieldsjoberg.com/gtsummary/articles/gtsummary_definition.html}{additional, hidden structure}
not present in the result of \code{tbl_listing()}. If you do need to report
the results of \code{tbl_listing()} in-line, it's recommended to convert
the table to a data frame, then extract the needed cell, e.g.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_listing() |>
  as_tibble(col_names = FALSE) |>
  dplyr::slice(1) |>
  dplyr::pull(colname)`
}\if{html}{\out{</div>}}
}

\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_listing_ex1.png}{options: width=65\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_listing_ex2.png}{options: width=75\%}}
}

\examples{
library(dplyr, warn.conflicts = FALSE)

tbl_listing_ex1 <-
  head(df_adverse_events, n = 10) \%>\%
  select(system_organ_class, adverse_event, grade, drug_attribution, patient_id) \%>\%
  arrange(adverse_event, desc(grade)) \%>\%
  tbl_listing(group_by = system_organ_class) \%>\%
  bold_labels()

set.seed(11234)
tbl_listing_ex2 <-
df_patient_characteristics \%>\%
  dplyr::slice_sample(n = 10) \%>\%
  select(patient_id, status, discontinued, off_trt_ae) \%>\%
  tbl_listing() \%>\%
  as_gt() \%>\%
  gt::opt_row_striping()

}
