% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setHandleParameters.R
\name{setHandleParameters}
\alias{setHandleParameters}
\title{If \code{gtrends} should be used behind a proxy,
especially with NTLM authentication mode,
you need to set the proxy parameters and credentials using "setHandleParameters" function}
\usage{
setHandleParameters(
  user = NULL,
  password = NULL,
  domain = NULL,
  proxyhost = NULL,
  proxyport = 8080,
  proxyauth = 15
)
}
\arguments{
\item{user}{A string specifying your username}

\item{password}{A string specifying your password}

\item{domain}{A string specifying the authentication domain}

\item{proxyhost}{A string specifying the Proxy host DNS or IP address}

\item{proxyport}{A numeric specifying the Proxy Port : 8080 (default)}

\item{proxyauth}{A numeric specifying the Proxy Authentication Method :
 0 for NONE
 1 for BASIC
 2 for DIGEST
 4 for NEGOTIATE
 8 for NTLM
15 for ANY (default)}
}
\description{
If \code{gtrends} should be used behind a proxy,
especially with NTLM authentication mode,
you need to set the proxy parameters and credentials using "setHandleParameters" function
}
\examples{

\dontrun{
library(gtrendsR)

setHandleParameters(user="xxxx",password="*******",domain="mydomain",proxyhost = "10.111.124.113")
res <- gtrends(c("nhl", "nba"), geo = c("CA", "US"))
}
}
