% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_p.R
\name{add_p_}
\alias{add_p_}
\title{Standard evaluation version of add_p()}
\usage{
add_p_(x, test = NULL, pvalue_fun = NULL, group = NULL,
  include = NULL, exclude = NULL)
}
\arguments{
\item{x}{Object with class \code{tbl_summary} from the \link{tbl_summary} function}

\item{test}{List of formulas specifying statistical tests to perform,
e.g. \code{list(all_continuous() ~ "t.test", all_categorical() ~ "fisher.test")}.
Options include
\itemize{
\item \code{"t.test"} for a t-test,
\item \code{"wilcox.test"} for a Wilcoxon rank-sum test,
\item \code{"kruskal.test"} for a Kruskal-Wallis rank-sum test,
\item \code{"chisq.test"} for a Chi-squared test of independence,
\item \code{"fisher.test"} for a Fisher's exact test,
\item \code{"lme4"} for a random intercept logistic regression model to account for
clustered data, \code{lme4::glmer(by ~ variable + (1 | group), family = binomial)}.
The \code{by} argument must be binary for this option.
}

Tests default to \code{"kruskal.test"} for continuous variables, \code{"chisq.test"} for
categorical variables with all expected cell counts >=5, and \code{"fisher.test"}
for categorical variables with any expected cell count <5.
A custom test function can be added for all or some variables. See below for
an example.}

\item{pvalue_fun}{Function to round and format p-values.
Default is \link{style_pvalue}.
The function must have a numeric vector input (the numeric, exact p-value),
and return a string that is the rounded/formatted p-value (e.g.
\code{pvalue_fun = function(x) style_pvalue(x, digits = 2)} or equivalently,
\code{purrr::partial(style_pvalue, digits = 2)}).}

\item{group}{Column name of an ID or grouping variable. The column can be
used calculate p-values with correlated data (e.g. when the test argument
is \code{"lme4"}). Default is \code{NULL}.  If specified,
the row associated with this variable is omitted from the summary table.}

\item{include}{Character vector of variable names to include from output.}

\item{exclude}{Character vector of variable names to exclude from output.}
}
\description{
The \code{'group ='} argument can be passed as a string, rather than with non-standard
evaluation as in \link{add_p}. Review the help file for \link{add_p} fully documented
options and arguments.
}
