% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_kable.R
\name{as_kable}
\alias{as_kable}
\title{Convert to knitr_kable object}
\usage{
as_kable(x, include = NULL, exclude = NULL, ...)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Character vector naming kable commands to include in printing.
Default is \code{NULL}, which utilizes all commands in \code{x$kable_calls}.}

\item{exclude}{Character vector naming kable commands to exclude in printing.
Default is \code{NULL}.}

\item{...}{Additional arguments passed to \link[knitr:kable]{knitr::kable}}
}
\value{
A \code{knitr_kable} object
}
\description{
Function converts gtsummary objects to a knitr_kable objects.  This function
is used in the background when the results are printed or knit.  A user can
use this function if they wish to add customized formatting available
via \link[knitr:kable]{knitr::kable}.
}
\examples{
trial \%>\%
  tbl_summary(by = trt) \%>\%
  as_kable()
}
\seealso{
\link{tbl_summary} \link{tbl_regression} \link{tbl_uvregression} \link{tbl_survival}
}
\author{
Daniel D. Sjoberg
}
