% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_p.R
\name{sort_p.tbl_uvregression}
\alias{sort_p.tbl_uvregression}
\title{Sort variables in table by ascending p-values}
\usage{
\method{sort_p}{tbl_uvregression}(x, q = FALSE, ...)
}
\arguments{
\item{x}{an object created using \code{tbl_uvregression} function}

\item{q}{logical argument. When \code{TRUE} will sort by the q-value column
rather than the p-values}

\item{...}{Not used}
}
\value{
A \code{tbl_uvregression} object
}
\description{
Sort variables in tables created by \link{tbl_uvregression} by ascending p-values
}
\section{Example Output}{

\if{html}{\figure{tbl_uvglm_sort_p_ex.png}{options: width=50\%}}
}

\examples{
tbl_uvglm_sort_p_ex <-
  trial \%>\%
  dplyr::select(age, marker, response, grade) \%>\%
  tbl_uvregression(
    method = glm,
    y = response,
    method.args = list(family = binomial),
    exponentiate = TRUE
  ) \%>\%
  sort_p()
}
\seealso{
Other tbl_uvregression tools: \code{\link{add_global_p.tbl_uvregression}},
  \code{\link{add_nevent.tbl_uvregression}},
  \code{\link{add_q.tbl_uvregression}},
  \code{\link{bold_italicize_labels_levels}},
  \code{\link{bold_p.tbl_stack}},
  \code{\link{bold_p.tbl_uvregression}},
  \code{\link{inline_text.tbl_uvregression}},
  \code{\link{modify_header}}, \code{\link{tbl_merge}},
  \code{\link{tbl_stack}}, \code{\link{tbl_uvregression}}
}
\author{
Karissa Whiting
}
\concept{tbl_uvregression tools}
