% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_terms.R
\name{combine_terms}
\alias{combine_terms}
\title{Combine terms in a regression model}
\usage{
combine_terms(x, formula_update, label = NULL, quiet = NULL, ...)
}
\arguments{
\item{x}{a \code{tbl_regression} object}

\item{formula_update}{formula update passed to the \link[stats:update]{stats::update}.
This updated formula is used to construct a reduced model, and is
subsequently passed to \code{\link[stats:anova]{stats::anova()}} to calculate the p-value for the
group of removed terms.  See the \link[stats:update]{stats::update} help file for proper syntax.
function's \verb{formula.=} argument}

\item{label}{Option string argument labeling the combined rows}

\item{quiet}{Logical indicating whether to print messages in console. Default is
\code{FALSE}}

\item{...}{Additional arguments passed to \link[stats:anova]{stats::anova}}
}
\value{
\code{tbl_regression} object
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
The function combines terms from a regression model, and replaces the terms
with a single row in the output table.  The p-value is calculated using
\code{\link[stats:anova]{stats::anova()}}.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{combine_terms_ex1.png}{options: width=45\%}}

\if{html}{Example 2}

\if{html}{\figure{combine_terms_ex2.png}{options: width=45\%}}

\if{html}{Example 3}

\if{html}{\figure{combine_terms_ex3.png}{options: width=45\%}}
}

\examples{
# Example 1 ----------------------------------
# fit model with nonlinear terms for marker
nlmod1 <- lm(
  age ~ marker + I(marker^2) + grade,
  trial[c("age", "marker", "grade")] \%>\% na.omit() # keep complete cases only!
)

combine_terms_ex1 <-
  tbl_regression(nlmod1, label = grade ~ "Grade") \%>\%
  # collapse non-linear terms to a single row in output using anova
  combine_terms(
    formula_update = . ~ . - marker - I(marker^2),
    label = "Marker (non-linear terms)"
  )

# Example 2 ----------------------------------
# Example with Cubic Splines
library(Hmisc, warn.conflicts = FALSE, quietly = TRUE)
mod2 <- lm(
  age ~ rcspline.eval(marker, inclx = TRUE) + grade,
  trial[c("age", "marker", "grade")] \%>\% na.omit() # keep complete cases only!
)

combine_terms_ex2 <-
  tbl_regression(mod2, label = grade ~ "Grade") \%>\%
  combine_terms(
    formula_update = . ~ . -rcspline.eval(marker, inclx = TRUE),
    label = "Marker (non-linear terms)"
  )

# Example 3 ----------------------------------
# Logistic Regression Example, LRT p-value
combine_terms_ex3 <-
  glm(
    response ~ marker + I(marker^2) + grade,
    trial[c("response", "marker", "grade")] \%>\% na.omit(), # keep complete cases only!
    family = binomial
  ) \%>\%
  tbl_regression(label = grade ~ "Grade", exponentiate = TRUE) \%>\%
  # collapse non-linear terms to a single row in output using anova
  combine_terms(
    formula_update = . ~ . - marker - I(marker^2),
    label = "Marker (non-linear terms)",
    test = "LRT"
  )

}
\seealso{
Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{add_nevent.tbl_regression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_footnote}()},
\code{\link{modify_header}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
