% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_gtsummary_theme.R
\name{set_gtsummary_theme}
\alias{set_gtsummary_theme}
\alias{reset_gtsummary_theme}
\title{Set a gtsummary theme}
\usage{
set_gtsummary_theme(x)

reset_gtsummary_theme()
}
\arguments{
\item{x}{A gtsummary theme function, e.g. \code{theme_gtsummary_journal()}, or a
named list defining a gtsummary theme. See details below.}
}
\description{
\lifecycle{maturing}
Use this function to set preferences for the display of gtsummary tables.
The default formatting and styling throughout the gtsummary package are
taken from the published reporting guidelines of the top four urology
journals: European Urology, The Journal of Urology, Urology and
the British Journal of Urology International. Use this function to change
the default reporting style to match another journal, or your own
personal style.
}
\section{Example Output}{

\if{html}{Example}

\if{html}{\figure{set_gtsummary_theme_ex1.png}{options: width=70\%}}
}

\examples{
# Setting JAMA theme for gtsummary
set_gtsummary_theme(theme_gtsummary_journal("jama"))
# Themes can be combined by including more than one
set_gtsummary_theme(theme_gtsummary_compact())

set_gtsummary_theme_ex1 <-
  trial \%>\%
  dplyr::select(age, grade, trt) \%>\%
  tbl_summary(by = trt) \%>\%
  add_stat_label() \%>\%
  as_gt()

# reset gtsummary theme
reset_gtsummary_theme()
}
\seealso{
\href{https://www.danieldsjoberg.com/gtsummary/articles/themes.html}{Themes vignette}

Available \link[=theme_gtsummary]{gtsummary themes}
}
