% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_ard_summary.R
\name{tbl_ard_summary}
\alias{tbl_ard_summary}
\title{ARD summary table}
\usage{
tbl_ard_summary(
  cards,
  by = NULL,
  statistic = list(all_continuous() ~ "{median} ({p25}, {p75})", all_categorical() ~
    "{n} ({p}\%)"),
  type = NULL,
  label = NULL,
  missing = c("no", "ifany", "always"),
  missing_text = "Unknown",
  missing_stat = "{N_miss}",
  include = everything(),
  overall = FALSE
)
}
\arguments{
\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to specify the summary statistics for each variable.
Each of the statistics must be present in \code{card} as no new statistics are calculated
in this function.
The default is
\code{list(all_continuous() ~ "{median} ({p25}, {p75})", all_categorical() ~ "{n} ({p}\%)")}.}

\item{type}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the summary type. Accepted value are
\code{c("continuous", "continuous2", "categorical", "dichotomous")}.
Continuous summaries may be assigned \code{c("continuous", "continuous2")}, while
categorical and dichotomous cannot be modified.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
Used to override default labels in summary table, e.g. \code{list(age = "Age, years")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}

\item{missing, missing_text, missing_stat}{Arguments dictating how and if missing values are presented:
\itemize{
\item \code{missing}: must be one of \code{c("no", "ifany", "always")}
\item \code{missing_text}: string indicating text shown on missing row. Default is \code{"Unknown"}
\item \code{missing_stat}: statistic to show on missing row. Default is \code{"{N_miss}"}.
Possible values are \code{N_miss}, \code{N_obs}, \code{N_nonmiss}, \code{p_miss}, \code{p_nonmiss}
}}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}}

\item{overall}{(scalar \code{logical})\cr
When \code{TRUE}, the \code{cards} input is parsed into two parts to run
\code{tbl_ard_summary(cards_by) |> add_overall(cards_overall)}.
Can only by used when \code{by} argument is specified.
Default is \code{FALSE}.}
}
\value{
a gtsummary table of class \code{"tbl_ard_summary"}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
The \code{tbl_ard_summary()} function tables descriptive statistics for
continuous, categorical, and dichotomous variables.
The functions accepts an ARD object.
}
\examples{
library(cards)

ard_stack(
  data = ADSL,
  ard_categorical(variables = "AGEGR1"),
  ard_continuous(variables = "AGE"),
  .attributes = TRUE,
  .missing = TRUE,
  .total_n = TRUE
) |>
  tbl_ard_summary()

ard_stack(
  data = ADSL,
  .by = ARM,
  ard_categorical(variables = "AGEGR1"),
  ard_continuous(variables = "AGE"),
  .attributes = TRUE,
  .missing = TRUE,
  .total_n = TRUE
) |>
  tbl_ard_summary(by = ARM)

ard_stack(
  data = ADSL,
  .by = ARM,
  ard_categorical(variables = "AGEGR1"),
  ard_continuous(variables = "AGE"),
  .attributes = TRUE,
  .missing = TRUE,
  .total_n = TRUE,
  .overall = TRUE
) |>
  tbl_ard_summary(by = ARM, overall = TRUE)
}
