% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_bold_italic.R
\name{modify_bold_italic}
\alias{modify_bold_italic}
\alias{modify_bold}
\alias{remove_bold}
\alias{modify_italic}
\alias{remove_italic}
\title{Modify Bold and Italic}
\usage{
modify_bold(x, columns, rows)

remove_bold(x, columns, rows)

modify_italic(x, columns, rows)

remove_italic(x, columns, rows)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to add footnote.

For \code{modify_footnote_spanning_header()}, pass a single column name where
the spanning header begins. If multiple column names are passed, only
the first is used.}

\item{rows}{(predicate \code{expression})\cr
Predicate expression to select rows in \code{x$table_body}.
Review \link[=rows_argument]{rows argument details}.}
}
\value{
Updated gtsummary object
}
\description{
Add or remove bold and italic styling to a cell in a table.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
tbl <- trial |>
  tbl_summary(include = grade) |>
  modify_bold(columns = label, rows = row_type == "label") |>
  modify_italic(columns = label, rows = row_type == "level")
tbl

# Example 2 ----------------------------------
tbl |>
  remove_bold(columns = label, rows = row_type == "label") |>
  remove_italic(columns = label, rows = row_type == "level")
\dontshow{\}) # examplesIf}
}
