% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guf.R
\name{right}
\alias{right}
\title{Get the specified right most characters of a string}
\usage{
right(string, nr_of_chars)
}
\arguments{
\item{string}{A character string, or a vector of character strings. This is the (vector of) character strings(s) of which the right most characters are to be returned.}

\item{nr_of_chars}{An integer or a vector of integers, specifying the right most number of characters to return. If both 'string' and 'nr_or_chars' are a vector, then the vector lengths must match.}
}
\value{
A character string, or a vector of character strings if the input is a vector.
}
\description{
right() counts from the right most position of a character string, for a specified number of characters, and returns the resulting substring. If the specified number of characters is more than the total length of the string, then the entire string will be returned.
}
\examples{
right("hello world", 3) # returns 'rld'
right(c("hello", "world"), 3) # returns vector c('llo', 'rld')
right(c("hello", "world"), c(1,3)) # returns vector c('o', 'rld')
right("hello world", 80) # returns 'hello world'
}
