% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browser.R
\name{open_in_gwas_catalog}
\alias{open_in_gwas_catalog}
\title{Browse GWAS Catalog entities from the GWAS Web Graphical User Interface}
\usage{
open_in_gwas_catalog(
  identifier,
  gwas_catalog_entity = c("study", "variant", "trait", "gene", "region", "publication")
)
}
\arguments{
\item{identifier}{A vector of identifiers. The identifiers can be: study
accession identifiers, variant identifiers, EFO trait identifiers, gene
symbol names, cytogenetic regions, or PubMed identifiers.}

\item{gwas_catalog_entity}{Either \code{'study'} (default), \code{'variant'},
\code{'trait'}, \code{'gene'}, \code{'region'} or \code{'publication'}, a
scalar character. This argument indicates the type of the identifiers
passed in \code{identifier}.}
}
\value{
Returns \code{TRUE} if successful, or \code{FALSE} otherwise. But
  note that this function is run for its side effect.
}
\description{
This function launches the web browser and opens a tab for each identifier on
the GWAS web graphical user interface: \url{https://www.ebi.ac.uk/gwas}.
}
\examples{
# Open studies in GWAS Web Graphical User Interface
open_in_gwas_catalog(c('GCST000016', 'GCST001115'))

# Open variants
open_in_gwas_catalog(c('rs146992477', 'rs56261590'),
  gwas_catalog_entity = 'variant')

# Open EFO traits
open_in_gwas_catalog(c('EFO_0004884', 'EFO_0004343'),
  gwas_catalog_entity = 'trait')

# Open genes
open_in_gwas_catalog(c('DPP6', 'MCCC2'),
  gwas_catalog_entity = 'gene')

# Open cytogenetic regions
open_in_gwas_catalog(c('2q37.1', '1p36.11'),
  gwas_catalog_entity = 'region')

# Open publications
open_in_gwas_catalog(c('25533513', '24376627'),
  gwas_catalog_entity = 'publication')

}
