% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.elliptical.R
\name{summary.elliptical}
\alias{summary.elliptical}
\alias{print.summary.elliptical}
\title{Summarizing Elliptical Model Fits.}
\usage{
\method{summary}{elliptical}(object, correlation = TRUE, ...)
}
\arguments{
\item{object}{an object with the result of the fitted elliptical regression model.}

\item{correlation}{a logical value to return the correlation for the estimated parameters. If \code{FALSE} (by default) not return the correlation matrix.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns an object of class \dQuote{summary.elliptical}, a list with follow components: 
\item{coefficients}{the matrix of coefficients, standard errors and significance values for parameters hypothesis test.}
\item{dispersion}{either the supplied argument or the estimated dispersion with standard error.}
\item{residuals}{the residuals from \code{object}.}
\item{cov.unscaled}{the unscaled (dispersion = 1) estimated covariance matrix of the estimated coefficients.}
\item{corrrelation}{the matrix of correlation for the estimated parameters.}  
\item{family}{family from \code{object}.}
\item{loglik}{the likelihood logarithm value from \code{object}.}
\item{terms}{the \code{terms} object used.}
\item{df}{degrees of fredom from \code{object}.}
\item{inter}{number of iterations of optimization process.}
\item{nas}{a logical vector indicating if there is \code{na} in estimation of coefficients.}
\item{call}{the matched call from \code{object}.}
\item{scale}{values of the \code{4d_g} for the specified distribution from \code{object}.}
\item{scaledispersion}{values of the \code{4f_g} for the specified distribution from \code{object}.}
}
\description{
This function produce result summary of the result of the fitted elliptical regression model.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5)
,data=luz)
summary(elliptical.fitt)
}
\references{
Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\url{https://doi.org/10.1016/j.spl.2007.01.012}
}
\seealso{
\code{\link{glm}}, \code{\link{elliptical}}, \code{\link{family.elliptical}}
}
\keyword{Elliptical}
\keyword{Linear}
\keyword{models}
\keyword{regression}
