% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.rbind}
\alias{h2o.rbind}
\title{Combine H2O Datasets by Rows}
\usage{
h2o.rbind(...)
}
\arguments{
\item{\dots}{A sequence of \linkS4class{H2OFrame} arguments. All datasets must exist on the same H2O instance
(IP and port) and contain the same number of rows.}
}
\value{
An \linkS4class{H2OFrame} object containing the combined \dots arguments column-wise.
}
\description{
Takes a sequence of H2O data sets and combines them by rows
}
\examples{
\dontrun{
library(h2o)
localH2O <- h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(localH2O, path = prosPath)
prostate.cbind <- h2o.rbind(prostate.hex, prostate.hex)
head(prostate.cbind)
}
}
\seealso{
\code{\link[base]{rbind}} for the base \code{R} method.
}

