% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.ifelse}
\alias{h2o.ifelse}
\alias{ifelse}
\title{H2O Apply Conditional Statement}
\usage{
h2o.ifelse(test, yes, no)

ifelse(test, yes, no)
}
\arguments{
\item{test}{A logical description of the condition to be met (>, <, =, etc...)}

\item{yes}{The value to return if the condition is TRUE.}

\item{no}{The value to return if the condition is FALSE.}
}
\value{
Returns a vector of new values matching the conditions stated in the ifelse call.
}
\description{
Applies conditional statements to numeric vectors in H2O parsed data objects when the data are
numeric.
}
\details{
Both numeric and categorical values can be tested. However when returning a yes and no condition
both conditions must be either both categorical or numeric.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
australia_path <- system.file("extdata", "australia.csv", package = "h2o")
australia <- h2o.importFile(path = australia_path)
australia[,9] <- ifelse(australia[,3] < 279.9, 1, 0)
summary(australia)
}
}
