% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.download_model}
\alias{h2o.download_model}
\title{Download the model in binary format.
The owner of the file saved is the user by which python session was executed.}
\usage{
h2o.download_model(
  model,
  path = NULL,
  export_cross_validation_predictions = FALSE
)
}
\arguments{
\item{model}{An H2OModel}

\item{path}{The path where binary file should be downloaded. Downloaded to current directory by default.}

\item{export_cross_validation_predictions}{A boolean flag indicating whether the download model should be
saved with CV Holdout Frame predictions. Default is not to export the predictions.}
}
\description{
Download the model in binary format.
The owner of the file saved is the user by which python session was executed.
}
\examples{
\dontrun{
library(h2o)
h <- h2o.init()
fr <- as.h2o(iris)
my_model <- h2o.gbm(x = 1:4, y = 5, training_frame = fr)
h2o.download_model(my_model)  # save to the current working directory
}
}
