% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Attribute.R
\docType{class}
\name{Attribute}
\alias{Attribute}
\alias{Attribute-class}
\alias{readAttribute}
\alias{readAttribute,Attribute-method}
\alias{writeAttribute}
\alias{writeAttribute,Attribute-method}
\title{The Attribute Class}
\usage{
writeAttribute(.Object, data = GetDimensions(data), transpose = TRUE)

\S4method{writeAttribute}{Attribute}(.Object, data = GetDimensions(data),
  transpose = TRUE)

readAttribute(.Object)

\S4method{readAttribute}{Attribute}(.Object)
}
\arguments{
\item{.Object}{Attribute; S4 object of class \code{Attribute}.}

\item{data}{object; Object to be stored in HDF5 file, can be either of type
vector, matrix or array.}

\item{transpose}{logical; Determine if data object should be
transposed.}
}
\description{
An HDF5 \code{Attribute} object is used to store meta data about a primary
data object like \code{\link{DataSet}}, \code{\link{H5Group}} or
\code{\link{H5File}}. The functions described in this section show a
low--level interface to read and write attributes. See
\code{\link{H5Location}} for the easier-to-use \code{\link{h5attr}}
convenience functions.
}
\details{
\code{Attribute}s are assumed to be like small \code{\link{DataSet}}s since
they can store the same data types in homogeneous objects like vectors,
matrices and arrays. However, there are two important differences compared to
\code{\link{DataSet}} objects:
\enumerate{
  \item{Attributes do not support compression or chunking.}
  \item{Subsetting is not possible for attribute data.}
}
}
\references{
\url{http://www.hdfgroup.org/HDF5/doc/UG/13_Attributes.html}
}
\seealso{
\code{\link{H5Location-Attribute}}
}

