% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choiceRT_ddm.R
\name{choiceRT_ddm}
\alias{choiceRT_ddm}
\title{Choice Reaction Time Task}
\usage{
choiceRT_ddm(data = "choose", niter = 4000, nwarmup = 1000,
  nchain = 4, ncore = 1, nthin = 1, inits = "random",
  indPars = "mean", modelRegressor = FALSE, vb = FALSE,
  inc_postpred = FALSE, adapt_delta = 0.95, stepsize = 1,
  max_treedepth = 10, ...)
}
\arguments{
\item{data}{A .txt file containing the data to be modeled. Data columns should be labeled as:
"subjID", "choice", "RT". See \bold{Details} below for more information.}

\item{niter}{Number of iterations, including warm-up. Defaults to 4000.}

\item{nwarmup}{Number of iterations used for warm-up only. Defaults to 1000.}

\item{nchain}{Number of Markov chains to run. Defaults to 4.}

\item{ncore}{Number of CPUs to be used for running. Defaults to 1.}

\item{nthin}{Every \code{i == nthin} sample will be used to generate the posterior distribution.
Defaults to 1. A higher number can be used when auto-correlation within the MCMC sampling is
high.}

\item{inits}{Character value specifying how the initial values should be generated. Options are
"fixed" or "random", or your own initial values.}

\item{indPars}{Character value specifying how to summarize individual parameters. Current options
are: "mean", "median", or "mode".}

\item{modelRegressor}{Export model-based regressors? TRUE or FALSE.
Currently not available for this model.}

\item{vb}{Use variational inference to approximately draw from a posterior distribution. Defaults
to FALSE.}

\item{inc_postpred}{\strong{(Currently not available.)}
Include trial-level posterior predictive simulations in model output (may greatly increase file
size). Defaults to FALSE.}

\item{adapt_delta}{Floating point value representing the target acceptance probability of a new
sample in the MCMC chain. Must be between 0 and 1. See \bold{Details} below.}

\item{stepsize}{Integer value specifying the size of each leapfrog step that the MCMC sampler can
take on each new iteration. See \bold{Details} below.}

\item{max_treedepth}{Integer value specifying how many leapfrog steps the MCMC sampler can take
on each new iteration. See \bold{Details} below.}

\item{...}{For this model, it's possible to set the following \strong{model-specific argument} to a value that you may prefer. \cr
\code{RTbound}: Floating point value representing the lower bound (i.e., minimum allowed) reaction time. Defaults to 0.1 (100 milliseconds).}
}
\value{
A class "hBayesDM" object \code{modelData} with the following components:
\describe{
  \item{\code{model}}{Character value that is the name of the model ("choiceRT_ddm").}
  \item{\code{allIndPars}}{Data.frame containing the summarized parameter values (as specified by
    \code{indPars}) for each subject.}
  \item{\code{parVals}}{List object containing the posterior samples over different parameters.}
  \item{\code{fit}}{A class \code{\link[rstan]{stanfit}} object that contains the fitted Stan
    model.}
  \item{\code{rawdata}}{Data.frame containing the raw data used to fit the model, as specified by
    the user.}
  
  
  
}
}
\description{
Hierarchical Bayesian Modeling of the Choice Reaction Time Task with the following parameters:
  "alpha" (boundary separation), "beta" (bias), "delta" (drift rate), "tau" (non-decision time).

\strong{MODEL:} Drift Diffusion Model (Ratcliff, 1978, Psychological Review)\cr *Note that this implementation is \strong{not} the full Drift Diffusion Model as described in Ratcliff (1978). This implementation estimates the drift rate, boundary separation, starting point, and non-decision time; but not the between- and within-trial variances in these parameters.

Code for this model is based on codes/comments by Guido Biele, Joseph Burling, Andrew Ellis, and potential others @ Stan mailing

Parameters of the DDM (parameter names in Ratcliff), from \url{https://github.com/gbiele/stan_wiener_test/blob/master/stan_wiener_test.R}
\cr - alpha (a): Boundary separation or Speed-accuracy trade-off (high alpha means high accuracy). 0 < alpha
\cr - beta (b): Initial bias, for either response (beta > 0.5 means bias towards "upper" response 'A'). 0 < beta < 1
\cr - delta (v): Drift rate; Quality of the stimulus (delta close to 0 means ambiguous stimulus or weak ability). 0 < delta
\cr - tau (ter): Non-decision time + Motor response time + encoding time (high means slow encoding, execution). 0 < tau (in seconds)
}
\details{
This section describes some of the function arguments in greater detail.

\strong{data} should be assigned a character value specifying the full path and name (including
  extension information, e.g. ".txt") of the file that contains the behavioral data-set of all
  subjects of interest for the current analysis. The file should be a \strong{tab-delimited} text
  file, whose rows represent trial-by-trial observations and columns represent variables.\cr
For the Choice Reaction Time Task, there should be 3 columns of data with the
  labels "subjID", "choice", "RT". It is not necessary for the columns to be in this particular order,
  however it is necessary that they be labeled correctly and contain the information below:
\describe{
  \item{"subjID"}{A unique identifier for each subject in the data-set.}
  \item{"choice"}{Choice made for the current trial, coded as \code{1}/\code{2} to indicate lower/upper boundary or left/right choices (e.g., 1 1 1 2 1 2).}
  \item{"RT"}{Choice reaction time for the current trial, in \strong{seconds} (e.g., 0.435 0.383 0.314 0.309, etc.).}
  
  
  
  
  
  
}
\strong{*}Note: The file may contain other columns of data (e.g. "ReactionTime", "trial_number",
  etc.), but only the data within the column names listed above will be used during the modeling.
  As long as the necessary columns mentioned above are present and labeled correctly, there is no
  need to remove other miscellaneous data columns.

\strong{nwarmup} is a numerical value that specifies how many MCMC samples should not be stored
  upon the beginning of each chain. For those familiar with Bayesian methods, this is equivalent
  to burn-in samples. Due to the nature of the MCMC algorithm, initial values (i.e. where the
  sampling chains begin) can have a heavy influence on the generated posterior distributions. The
  \code{nwarmup} argument can be set to a high number in order to curb the effects that initial
  values have on the resulting posteriors.

\strong{nchain} is a numerical value that specifies how many chains (i.e. independent sampling
  sequences) should be used to draw samples from the posterior distribution. Since the posteriors
  are generated from a sampling process, it is good practice to run multiple chains to ensure
  that a reasonably representative posterior is attained. When the sampling is complete, it is
  possible to check the multiple chains for convergence by running the following line of code:
  \code{plot(output, type = "trace")}. The trace-plot should resemble a "furry caterpillar".

\strong{nthin} is a numerical value that specifies the "skipping" behavior of the MCMC sampler,
  using only every \code{i == nthin} samples to generate posterior distributions. By default,
  \code{nthin} is equal to 1, meaning that every sample is used to generate the posterior.

\strong{Control Parameters:} \code{adapt_delta}, \code{stepsize}, and \code{max_treedepth} are
  advanced options that give the user more control over Stan's MCMC sampler. It is recommended
  that only advanced users change the default values, as alterations can profoundly change the
  sampler's behavior. Refer to 'The No-U-Turn Sampler: Adaptively Setting Path Lengths in
  Hamiltonian Monte Carlo (Hoffman & Gelman, 2014, Journal of Machine Learning Research)' for
  more information on the sampler control parameters. One can also refer to 'Section 34.2. HMC
  Algorithm Parameters' of the \href{http://mc-stan.org/users/documentation/}{Stan User's Guide
  and Reference Manual}, or to the help page for \code{\link[rstan]{stan}} for a less technical
  description of these arguments.
}
\examples{
\dontrun{
# Run the model and store results in "output"
output <- choiceRT_ddm("example", niter = 2000, nwarmup = 1000, nchain = 4, ncore = 4)

# Visually check convergence of the sampling chains (should look like 'hairy caterpillars')
plot(output, type = "trace")

# Check Rhat values (all Rhat values should be less than or equal to 1.1)
rhat(output)

# Plot the posterior distributions of the hyper-parameters (distributions should be unimodal)
plot(output)

# Show the WAIC and LOOIC model fit estimates
printFit(output)
}
}
\references{
Ratcliff, R. (1978). A theory of memory retrieval. Psychological Review, 85(2), 59-108. http://doi.org/10.1037/0033-295X.85.2.59
}
\seealso{
We refer users to our in-depth tutorial for an example of using hBayesDM:
  \url{https://rpubs.com/CCSL/hBayesDM}
}
