% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchyWide.R
\name{hierarchyWide}
\alias{hierarchyWide}
\title{hierarchyWide}
\usage{
hierarchyWide(ee, supv)
}
\arguments{
\item{ee}{An array containing unique identifers for employees.}

\item{supv}{An array containing unique identifiers for supervisors. These values should be
of the same type as the employee values.}
}
\value{
data frame
}
\description{
The hierarchyWide function transforms a standard set of unique employee and supervisor
identifiers (employee IDs, email addresses, etc.) into a wide format that can be used to aggregate 
employee data by a particular line of leadership (i.e. include everyone who rolls up to Susan). The 
function returns a wide data frame with a column for every level in the hierarchy, 
starting from the top of the tree (i.e. "Supv1" is likely the CEO in your organization).
}
\examples{
ee = c("Dale@hR.com","Bob@hR.com","Julie@hR.com","Andrea@hR.com")
supv = c("Julie@hR.com","Julie@hR.com","Andrea@hR.com","Susan@hR.com")
hierarchyWide(ee,supv)
}
