#include <stdlib.h> // for NULL
#include <R_ext/Rdynload.h>

// File skeleton generated with:
// tools::package_native_routine_registration_skeleton(".", "src/hSDM_init.c")
// Function prototypes generated with cproto (https://invisible-island.net/cproto/cproto.html):
// $ cd ~/Code/hSDM/src
// $ cproto -I/usr/share/R/include/ -e *.c

/* .C calls */
extern void hSDM_binomial(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *np, const int *Y_vect, const int *T_vect, const double *X_vect, const int *npred, const double *X_pred_vect, const double *beta_start, double *beta_vect, const double *mubeta, double *Vbeta, double *Deviance, double *theta_latent, double *theta_pred, const int *seed, const int *verbose, const int *save_p);
extern void hSDM_binomial_iCAR(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *ncell, const int *np, const int *Y_vect, const int *T_vect, const double *X_vect, const int *C_vect, const int *nNeigh, const int *Neigh_vect, const int *npred, const double *X_pred_vect, const int *C_pred_vect, const double *beta_start, const double *rho_start, double *beta_vect, double *rho_pred, double *Vrho, const double *mubeta, double *Vbeta, const double *priorVrho, const double *shape, double *rate, const double *Vrho_max, double *Deviance, double *theta_latent, double *theta_pred, const int *seed, const int *verbose, const int *save_rho, const int *save_p);
extern void hSDM_Nmixture(const int *ngibbs, int *nthin, int *nburn, const int *nobs, int *nsite, const int *np, const int *nq, const int *Y_vect, const double *W_vect, const double *X_vect, const int *S_vect, const int *npred, const double *X_pred_vect, const double *beta_start, const double *gamma_start, const int *N_start, double *beta_vect, double *gamma_vect, int *N_pred, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, double *Deviance, double *lambda_latent, double *delta_latent, double *lambda_pred, const int *seed, const int *verbose, const int *save_p, const int *save_N);
extern void hSDM_Nmixture_iCAR(const int *ngibbs, int *nthin, int *nburn, const int *nobs, int *nsite, int *ncell, const int *np, const int *nq, const int *Y_vect, const double *W_vect, const double *X_vect, const int *S_vect, const int *C_vect, const int *nNeigh, const int *Neigh_vect, const int *npred, const double *X_pred_vect, const int *C_pred_vect, const double *beta_start, const double *gamma_start, const double *rho_start, const int *N_start, double *beta_vect, double *gamma_vect, double *rho_pred, double *Vrho, int *N_pred, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, const double *priorVrho, const double *shape, double *rate, const double *Vrho_max, double *Deviance, double *lambda_latent, double *delta_latent, double *lambda_pred, const int *seed, const int *verbose, const int *save_rho, const int *save_p, const int *save_N);
extern void hSDM_Nmixture_K(const int *ngibbs, int *nthin, int *nburn, const int *nobs, int *nsite, const int *np, const int *nq, const int *Y_vect, const double *W_vect, const double *X_vect, const int *N_max, const int *K, const int *S_vect, const int *npred, const double *X_pred_vect, const double *beta_start, const double *gamma_start, double *beta_vect, double *gamma_vect, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, double *Deviance, double *lambda_latent, double *delta_latent, double *lambda_pred, const int *seed, const int *verbose, const int *save_p);
extern void hSDM_poisson(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *np, const int *Y_vect, const double *X_vect, const int *npred, const double *X_pred_vect, const double *beta_start, double *beta_vect, const double *mubeta, double *Vbeta, double *Deviance, double *lambda_latent, double *lambda_pred, const int *seed, const int *verbose, const int *save_p);
extern void hSDM_poisson_iCAR(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *ncell, const int *np, const int *Y_vect, const double *X_vect, const int *C_vect, const int *nNeigh, const int *Neigh_vect, const int *npred, const double *X_pred_vect, const int *C_pred_vect, const double *beta_start, const double *rho_start, double *beta_vect, double *rho_pred, double *Vrho, const double *mubeta, double *Vbeta, const double *priorVrho, const double *shape, double *rate, const double *Vrho_max, double *Deviance, double *lambda_latent, double *lambda_pred, const int *seed, const int *verbose, const int *save_rho, const int *save_p);
extern void hSDM_siteocc(const int *ngibbs, int *nthin, int *nburn, const int *nobs, int *nsite, const int *np, const int *nq, const int *Y_vect, const double *W_vect, const double *X_vect, const int *S_vect, const int *npred, const double *X_pred_vect, const double *beta_start, const double *gamma_start, double *beta_vect, double *gamma_vect, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, double *Deviance, double *theta_latent, double *delta_latent, double *theta_pred, const int *seed, const int *verbose, const int *save_p);
extern void hSDM_siteocc_iCAR(const int *ngibbs, int *nthin, int *nburn, const int *nobs, int *nsite, int *ncell, const int *np, const int *nq, const int *Y_vect, const double *W_vect, const double *X_vect, const int *S_vect, const int *C_vect, const int *nNeigh, const int *Neigh_vect, const int *npred, const double *X_pred_vect, const int *C_pred_vect, const double *beta_start, const double *gamma_start, const double *rho_start, double *beta_vect, double *gamma_vect, double *rho_pred, double *Vrho, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, const double *priorVrho, const double *shape, double *rate, const double *Vrho_max, double *Deviance, double *theta_latent, double *delta_latent, double *theta_pred, const int *seed, const int *verbose, const int *save_rho, const int *save_p);
extern void hSDM_ZIB(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *np, const int *nq, const int *Y_vect, const int *T_vect, const double *X_vect, const double *W_vect, const int *npred, const double *X_pred_vect, const double *beta_start, const double *gamma_start, double *beta_vect, double *gamma_vect, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, double *Deviance, double *prob_p_latent, double *prob_q_latent, double *prob_p_pred, const int *seed, const int *verbose, const int *save_p);
extern void hSDM_ZIB_iCAR(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *ncell, const int *np, const int *nq, const int *Y_vect, const int *T_vect, const double *X_vect, const double *W_vect, const int *C_vect, const int *nNeigh, const int *Neigh_vect, const int *npred, const double *X_pred_vect, const int *C_pred_vect, const double *beta_start, const double *gamma_start, const double *rho_start, double *beta_vect, double *gamma_vect, double *rho_pred, double *Vrho, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, const double *priorVrho, const double *shape, double *rate, const double *Vrho_max, double *Deviance, double *prob_p_latent, double *prob_q_latent, double *prob_p_pred, const int *seed, const int *verbose, const int *save_rho, const int *save_p);
extern void hSDM_ZIB_iCAR_alteration(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *ncell, const int *np, const int *nq, const int *Y_vect, const int *T_vect, const double *X_vect, const double *W_vect, const double *U_vect, const int *C_vect, const int *nNeigh, const int *Neigh_vect, const int *npred, const double *X_pred_vect, const int *C_pred_vect, const double *beta_start, const double *gamma_start, const double *rho_start, double *beta_vect, double *gamma_vect, double *rho_pred, double *Vrho, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, const double *priorVrho, const double *shape, double *rate, const double *Vrho_max, double *Deviance, double *prob_p_latent, double *prob_q_latent, double *prob_p_pred, const int *seed, const int *verbose, const int *save_rho, const int *save_p);
extern void hSDM_ZIP(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *np, const int *nq, const int *Y_vect, const double *X_vect, const double *W_vect, const int *npred, const double *X_pred_vect, const double *beta_start, const double *gamma_start, double *beta_vect, double *gamma_vect, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, double *Deviance, double *prob_p_latent, double *prob_q_latent, double *prob_p_pred, const int *seed, const int *verbose, const int *save_p);
extern void hSDM_ZIP_iCAR(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *ncell, const int *np, const int *nq, const int *Y_vect, const double *X_vect, const double *W_vect, const int *C_vect, const int *nNeigh, const int *Neigh_vect, const int *npred, const double *X_pred_vect, const int *C_pred_vect, const double *beta_start, const double *gamma_start, const double *rho_start, double *beta_vect, double *gamma_vect, double *rho_pred, double *Vrho, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, const double *priorVrho, const double *shape, double *rate, const double *Vrho_max, double *Deviance, double *prob_p_latent, double *prob_q_latent, double *prob_p_pred, const int *seed, const int *verbose, const int *save_rho, const int *save_p);
extern void hSDM_ZIP_iCAR_alteration(const int *ngibbs, int *nthin, int *nburn, const int *nobs, const int *ncell, const int *np, const int *nq, const int *Y_vect, const double *X_vect, const double *W_vect, const double *U_vect, const int *C_vect, const int *nNeigh, const int *Neigh_vect, const int *npred, const double *X_pred_vect, const int *C_pred_vect, const double *beta_start, const double *gamma_start, const double *rho_start, double *beta_vect, double *gamma_vect, double *rho_pred, double *Vrho, const double *mubeta, double *Vbeta, const double *mugamma, double *Vgamma, const double *priorVrho, const double *shape, double *rate, const double *Vrho_max, double *Deviance, double *prob_p_latent, double *prob_q_latent, double *prob_p_pred, const int *seed, const int *verbose, const int *save_rho, const int *save_p);

static const R_CMethodDef CEntries[] = {
    {"hSDM_binomial",            (DL_FUNC) &hSDM_binomial,            20},
    {"hSDM_binomial_iCAR",       (DL_FUNC) &hSDM_binomial_iCAR,       33},
    {"hSDM_Nmixture",            (DL_FUNC) &hSDM_Nmixture,            31},
    {"hSDM_Nmixture_iCAR",       (DL_FUNC) &hSDM_Nmixture_iCAR,       44},
    {"hSDM_Nmixture_K",          (DL_FUNC) &hSDM_Nmixture_K,          30},
    {"hSDM_poisson",             (DL_FUNC) &hSDM_poisson,             19},
    {"hSDM_poisson_iCAR",        (DL_FUNC) &hSDM_poisson_iCAR,        32},
    {"hSDM_siteocc",             (DL_FUNC) &hSDM_siteocc,             28},
    {"hSDM_siteocc_iCAR",        (DL_FUNC) &hSDM_siteocc_iCAR,        41},
    {"hSDM_ZIB",                 (DL_FUNC) &hSDM_ZIB,                 27},
    {"hSDM_ZIB_iCAR",            (DL_FUNC) &hSDM_ZIB_iCAR,            40},
    {"hSDM_ZIB_iCAR_alteration", (DL_FUNC) &hSDM_ZIB_iCAR_alteration, 41},
    {"hSDM_ZIP",                 (DL_FUNC) &hSDM_ZIP,                 26},
    {"hSDM_ZIP_iCAR",            (DL_FUNC) &hSDM_ZIP_iCAR,            39},
    {"hSDM_ZIP_iCAR_alteration", (DL_FUNC) &hSDM_ZIP_iCAR_alteration, 40},
    {NULL, NULL, 0}
};

void R_init_hSDM(DllInfo *dll)
{
    R_registerRoutines(dll, CEntries, NULL, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
