% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_latest_show_stories}
\alias{get_latest_show_stories}
\title{Hacker News latest show stories}
\usage{
get_latest_show_stories(max_items = NULL)
}
\arguments{
\item{max_items}{Maximum number of items to retrieve.
If max_items = NULL, returns all available}
}
\value{
list of latest show HN stories
}
\description{
Retrieves latest show stories using Hacker News API
}
\details{
Parallel api requests can be enabled by running
\code{future::plan(future::multiprocess)}
}
\examples{
# get the latest show story on Hacker News
latest_show_story <- get_latest_show_stories(max_items = 1)
latest_show_story

\donttest{
# get 10 latest show stories on Hacker News
latest_10_show_stories <- get_latest_show_stories(max_items = 10)
latest_10_show_stories

# get all latest show stories on Hacker News
latest_show_stories <- get_latest_show_stories()
latest_show_stories
}
}
