% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs.mpia0.R
\name{fs.a0}
\alias{fs.a0}
\title{Finite Size Corrections to \eqn{q\cot\delta}{qcotdelta} for I=2
\eqn{\pi\pi}{pipi} near threshold}
\usage{
fs.a0(a0, mps, L)
}
\arguments{
\item{a0}{scattering length at finite L}

\item{mps}{pion mass as a scalar variable (must not be a vector)}

\item{L}{spatial lattice extent as a scalar variable (must not be a vector)}
}
\value{
returns a numeric value representing the finite size correction or
in case of \code{fs.a0} the corrected value for a0.
}
\description{
\code{fs.qcotdelta} computes the finite size corrections to
\eqn{q\cot\delta}{qcotdelta} while \code{fs.mpia0} computes the
corresponding finite size corrections to \eqn{M_\pi a_0}{Mpi a0} directly
using the Gasser Leutwyler result from \eqn{M_\pi}{Mpi}.
}
\examples{
fs.a0(a0=1., mps=0.123, L=24)
}
\references{
For the original formula see Eq. (31) from hep-lat/0601033
}
\author{
Carsten Urbach, \email{curbach@gmx.de}
}
