% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hadron-package.R
\docType{package}
\name{hadron}
\alias{hadron}
\title{The Hadron Package}
\description{
An R implementation of fitting routines used in lattice QCD. It provides
useful functions for extraction hadronic quantities and such like.
}
\details{
Toolkit to perform statistical analyses of correlation
functions generated from Lattice Monte Carlo simulations. In
particular, a class \code{cf} for correlation functions and
methods to analyse those are defined. This includes (blocked)
bootstrap and jackknife, but also an automatic determination of
integrated autocorrelation times. \code{hadron} also provides a very
general function \code{bootstrap.nlsfit} to bootstrap a non-linear least squares fit.
More specific functions are provided to extract hadronic quantities
from Lattice Quantum Chromodynamics simulations, a particular Monte
Carlo simulation,(see e.g. European Twisted Mass Collaboration, P. Boucaud et
al. (2008) \doi{10.1016/j.cpc.2008.06.013}). Here, to determine
energy eigenvalues of hadronic states, specific fitting routines
and in particular the generalised eigenvalue method (see
e.g. B. Blossier et al. (2009) \doi{10.1088/1126-6708/2009/04/094}
and M. Fischer et al. (2020)
\url{https://inspirehep.net/literature/1792113}) are implemented.
In addition, input/output and plotting routines are available.
}
\author{
Carsten Urbach, \email{urbach@hiskp.uni-bonn.de}
}
\keyword{package}
