% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{jackknife_error}
\alias{jackknife_error}
\title{Estimates error from jackknife samples}
\usage{
jackknife_error(samples, boot.l = 1, na.rm = FALSE)
}
\arguments{
\item{samples}{Numeric vector.}

\item{boot.l}{Block length for bootstrapping.}

\item{na.rm}{Logical. Determines whether \code{NA} values shall be removed, see
Description for details.}
}
\value{
returns a single numeric representing the jackknife estimate of error
}
\description{
Computes the jackknife error which is just
\deqn{\sum_{i=0}^N (x_i - \bar x)^2 \,.}
Internally we use
\deqn{\frac{(N-1)^2}{N} \mathop{\mathrm{sd}}(X)}
in order to benefit from the optimized standard deviation function.

The width of the bootstrap distribution does not change with the number of
elements. The jackknife distribution crucially depends on the number of
measurements that one started with. Therefore we cannot just drop the NA
values and are done with it. Instead we need to rescale with the
\eqn{\sqrt{N / m}} where \eqn{N} is the number of original measurements and
\eqn{m} is the number of non-NA values. With NA values removed we would
otherwise underestimate the uncertainty.
}
\details{
Currently this uses the mean over the jackknife samples in order to compute
the error. It would be better in the case of a bias to use the mean over the
original data instead. This would require a second parameter and therefore
is incompatible with the previously used \code{sd} everywhere for the bootstrap
samples. As the \code{sd} for the bootstrap samples also does not include the
original data, this likely is similar in terms of bias.
}
