% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{symmetrise.cf}
\alias{symmetrise.cf}
\title{Average backward and forward-dominated parts of the correlation function}
\usage{
symmetrise.cf(cf, sym.vec = c(1))
}
\arguments{
\item{cf}{Object of type \code{cf}.}

\item{sym.vec}{Integer or integer vector of length cf$nrObs giving the
time-reflection symmetry (1 for symmetric, -1 for anti-symmetric)
of the observable in question.}
}
\value{
Returns an object of class \code{cf}, which is the symmetrised version
of the input \code{cf} object.
}
\description{
When a correlation function is symmetric or anti-symmetric in time,
this symmetry can be exploited by averaging the part from source-sink
separation 1 to cf$Time/2 with the part from cf$Time/2+1 to cf$Time-1
in order to improve statistical precision. This function
reduces the number of time slices in a \code{cf} object from cf$Time to
cf$Time/2+1 by performing this averaging.
}
