% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeTemporal.cf.R
\name{weight.cf}
\alias{weight.cf}
\title{Weight a correlation function}
\usage{
weight.cf(cf, energy_difference_val, energy_difference_boot, cosh_factor,
  offset = 0, inverse = FALSE)
}
\arguments{
\item{cf}{cf_orig and possibly cf_boot object.}

\item{energy_difference_val}{numeric. A single energy value \eqn{\Delta E}{Delta E} for
the weighting.}

\item{energy_difference_boot}{numeric vector. Samples for the energy
difference value.}

\item{cosh_factor}{integer, either \code{+1} or \code{-1}. Determines the sign $c$ in
the weight factor.}

\item{offset}{integer. Offset for the time $t$, needed for the reweighting
after a shift.}

\item{inverse}{boolean. If \code{TRUE} apply inverse weight.}
}
\value{
Returns an object of class \code{cf}, see \link{cf}.
}
\description{
Weights a correlation function with the given energy difference \eqn{\Delta E}{Delta E}
such that the function is first multiplied with
\eqn{\exp(\Delta E t) + c \exp(\Delta E \cdot (Time - t)}{exp(Delta E t) + c exp(Delta E(Time-t))}.
}
