% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterModeling_plottingfunctions.R
\name{plot_cluster_fill_rates}
\alias{plot_cluster_fill_rates}
\title{Plot Cluster Fill Rates}
\usage{
plot_cluster_fill_rates(formatted_data, facet = FALSE)
}
\arguments{
\item{formatted_data}{Data created by \code{\link[=format_template_data]{format_template_data()}},
\code{\link[=fit_model]{fit_model()}}, or \code{\link[=analyze_questioned_documents]{analyze_questioned_documents()}}}

\item{facet}{\code{TRUE} uses \code{facet_wrap} to create a subplot for each writer.
\code{FALSE} plots the data on a single plot.}
}
\value{
ggplot plot of cluster fill rates
}
\description{
Plot the cluster fill rates for each document in \code{formatted_data}.
}
\examples{
# Plot cluster fill rates for template training documents
template_data <- format_template_data(example_cluster_template)
plot_cluster_fill_rates(formatted_data = template_data, facet = TRUE)

# Plot cluster fill rates for model training documents
plot_cluster_fill_rates(formatted_data = example_model_1chain, facet = TRUE)

# Plot cluster fill rates for questioned documents
plot_cluster_fill_rates(formatted_data = example_analysis_1chain, facet = FALSE)

}
