% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_plot.R
\name{plot_cluster_centers}
\alias{plot_cluster_centers}
\title{Plot Template Cluster Centers}
\usage{
plot_cluster_centers(template, plot_graphs = FALSE, size = 100)
}
\arguments{
\item{template}{A cluster template created with \code{\link{make_clustering_template}}}

\item{plot_graphs}{TRUE plots all graphs in each cluster in addition to the
cluster centers. FALSE only plots the cluster centers.}

\item{size}{The size of the output plot}
}
\value{
A plot
}
\description{
Plot the cluster centers of a cluster template created with
\code{\link{make_clustering_template}}. This function uses a K-Means type algorithm to
sort graphs from training documents into clusters. On each iteration of the
algorithm, it calculates the mean graph of each cluster and finds the graph
in each cluster that is closest to the mean graph. The graphs closest to the
mean graphs are used as the cluster centers for the next iteration.
Handwriter stores the cluster centers of a cluster template as graph
prototypes. A graph prototype consists of the starting and ending points of
each path in the graph, as well as and evenly spaced points along each path.
The prototype also stores the center point of the graph. All points are
represented as xy-coordinates and the center point is at (0,0).
}
\examples{
# plot cluster centers from example template
plot_cluster_centers(example_cluster_template)
plot_cluster_centers(example_cluster_template, plot_graphs = TRUE)

}
