% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_answered_questions.R
\name{commons_answered_questions}
\alias{commons_answered_questions}
\alias{hansard_commons_answered_questions}
\title{Imports data on House of Commons answered questions.}
\usage{
commons_answered_questions(answering_department = NULL, answered_by = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")

hansard_commons_answered_questions(answering_department = NULL,
  answered_by = NULL, start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{answering_department}{Returns a tibble with all answered questions in the House of Commons from the given department. Defaults to NULL.}

\item{answered_by}{Returns a tibble with all answered questions in the House of Commons by the given MP. Defaults to NULL.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on all answered questions in the House of Commons.
}
\description{
Imports data on House of Commons answered questions. If all parameters are left empty, imports all available answered questions in a tibble.
}
\examples{
\dontrun{

x <- commons_answered_questions(answering_department = 'health', answered_by = '4019')

x <- commons_answered_questions(start_date = '2017-03-26', end_date='2017-04-01')

}
}
\seealso{
\code{\link{all_answered_questions}}

\code{\link{commons_oral_questions}}

\code{\link{commons_oral_question_times}}

\code{\link{commons_written_questions}}

\code{\link{lords_written_questions}}

\code{\link{mp_questions}}
}
\keyword{bills}
