% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_apicarto_rpg.R
\name{get_apicarto_rpg}
\alias{get_apicarto_rpg}
\title{Apicarto RPG (Registre Parcellaire Graphique)}
\usage{
get_apicarto_rpg(x,
                 annee,
                 code_cultu = list(NULL),
                 dTolerance = 0)
}
\arguments{
\item{x}{Object of class \code{sf}. Needs to be located in France.}

\item{annee}{numeric between 2010 and 2021}

\item{code_cultu}{character corresponding to code culture, see detail.}

\item{dTolerance}{numeric; tolerance parameter. The value of \code{dTolerance}
must be specified in meters, see detail.}
}
\value{
\code{list} or object of class \code{sf}
}
\description{
Implementation of the "RPG" module from the
\href{https://apicarto.ign.fr/api/doc/rpg}{IGN's apicarto}. This function
is a wrapper around version 1 and 2 of the API.
}
\details{
Since 2014 the culture code has changed its format. Before it should be
a value ranging from "01" to "28", after it should be a trigram (ex : "MIE").
More info can be found at the
\href{https://apicarto.ign.fr/api/doc/pdf/docUser_moduleRPG.pdf}{documentation page}

\code{dTolerance} is needed when geometry are too complex. Its the same parameter
found in \code{sf::st_simlplify}.
}
\examples{
\dontrun{
library(sf)

penmarch <- get_apicarto_cadastre("29158", type = "commune")

# failure with too complex geom
rpg <- get_apicarto_rpg(penmarch, 2020)

# avoid complex data by setting dTolerance
rpg <- get_apicarto_rpg(penmarch, 2020, dTolerance = 10)

# multiple years after 2014
rpg <- get_apicarto_rpg(x, 2020:2021, dTolerance = 10)

# years before and after 2014
# list is returned because attributs are different
rpg <- get_apicarto_rpg(x, c(2010, 2021), dTolerance = 10)

# filter by code_cultu
rpg <- get_apicarto_rpg(x, 2021, code_cultu = "MIE", dTolerance = 10)

# all "MIE" from 2020 and all "PPH" from 2021
rpg <- get_apicarto_rpg(x, 2020:2021, code_cultu = c("MIE", "PPH"), dTolerance = 10)

# vectorization : all "MIE" from 2020 and 2021
rpg <- get_apicarto_rpg(x, 2020:2021, code_cultu = "MIE", dTolerance = 10)
}

}
